import sys,os

import ned_commandLine as commandline
import ned_fastaHelper as fastaHelper
import rje_disorder

class disorderScorer():
	def __init__(self):
		cmdline = commandline.CommandLine()
		self.options = cmdline.loadIniFile(os.path.join(os.path.dirname(os.path.realpath(__file__)),"../settings/utilities.ini"))
		
		if "disorderCutoff" not in self.options:
			self.options["disorderCutoff"] = 0
		
		self.data = {}
		
	def disorderFromFile(self,filePath,type="residue"):
		return self.disorderFromSequence(open(filePath,"r").read(),type)
	
	def disorderFromSequence(self,sequence,type="residue"):
		sequence = sequence.split('\n')
		
		if sequence[0][0] == ">":
			sequence = sequence[1:]
			
		self.data["Sequence"] = str("".join(sequence))
	
	
		#run IUPred
		dcmd = ['iucut=' + str(self.options["disorderCutoff"]),'iupath=' + self.options["iupath"],'sequence=%s' % self.data["Sequence"],'iuchdir=T',"i=-1","v=1"]
		disorderObj = rje_disorder.Disorder(cmd_list=dcmd)
		
		self.data['RegionDisorder'] = disorderObj.list['RegionDisorder']
		self.data['ResidueDisorder'] = disorderObj.list['ResidueDisorder']
		self.data['RegionOrder'] = disorderObj.list['RegionFold']
		
		self.orderedResidues()
		self.disorderedResidues()
		
		if type == "residue":
			return self.data['ResidueDisorder']
		
		if type == "region":
			return self.data['RegionDisorder']
		
		if type == "disorderedResidues":
			return self.data["disorderedResidues"]
		
		if type == "orderedResidues":
			return self.data["disorderedResidues"]
			
	def disorderedResidues(self):
		disorderedResidues = []
			
		for i in range(0,len(self.data['ResidueDisorder'])):
			if self.data['ResidueDisorder'][i] >= float(self.options["disorderCutoff"]):
				disorderedResidues.append(i)
		
		self.data["disorderedResidues"] = disorderedResidues
		
		
	def orderedResidues(self):
		orderedResidues = []
			
		for i in range(0,len(self.data['ResidueDisorder'])):
			if self.data['ResidueDisorder'][i] <= float(self.options["disorderCutoff"]):
				orderedResidues.append(i)
		
		self.data["orderedResidues"] = orderedResidues




if __name__ == "__main__":
	infile = sys.argv[1]
	fastaHelpObj = fastaHelper.fastaHelper()
	disScorer = disorderScorer()
	
	aaFreqs = {"A":0.035,"R":0.012,"N":0.019,"D":0.054,"C":0.001,"Q":0.027,"E":0.196,"G":0.050,"H":0.042,"I":0.031,"L":0.046,"K":0.162,"M":0.023,"F":0.027,"P":0.073,"S":0.069,"T":0.065,"W":0.001,"Y":0.008,"V":0.062}

	fastaHelpObj.readFastaDb(infile)
	count = 0
	aas = "ACDEFGHIKLMNPQRSTVWY"
	print 'score\tstart\tend\tuniprotId\tsequence\t'  +"\t".join(list(aas)) + "\n"
	for protein in fastaHelpObj.data:
		sequence = fastaHelpObj.data[protein]['sequence']
		disScorer.disorderFromSequence(sequence)
		for region in disScorer.data['RegionDisorder']:
			count += 1
			
			composition = True
			tmpStr = ""
			score = []
			subseq = sequence[region[0]:region[1]].replace("X","")
			if len(subseq) >= 20:
				for aa in list(aas):
					
					sequenceFreq = float(subseq.count(aa))/(region[1] - region[0])
					
					score.append(abs(sequenceFreq - aaFreqs[aa]))
					
					tmpStr +=  "\t%1.3f"%sequenceFreq
					
				print "%1.3f"%(max(score)) + "\t" + str(region[0]) + "\t" + str(region[1])  + "\t" + protein + "\t" + subseq + tmpStr
				
				
				
			else:
				pass
			
			
			
			
		