import os,urllib,sys


import ned_commandLine as commandline
from ned_sortedFileSearcher import Searcher

import ned_fastaHelper as fastaHelper

try:
	import gopher_V2
	
	import rje_seq,rje_tree,rje_slimcalc	
	
except Exception,e:
	print e
	sys.exit()

class alignmentHelper():		
	def __init__(self,disorder=None,pfam=None,features=None):
		cmdline = commandline.CommandLine()
		self.options = cmdline.loadIniFile(os.path.join(os.path.dirname(os.path.realpath(__file__)),"../settings/utilities.ini"))
		
	def makeAlignment(self,accession):
		try:
			fastahelper = fastaHelper.fastaHelper()
			fastahelper.fetchSequence(accession,os.path.join(self.options["uniprot_dir"],"fasta"))	
			
			cmd_list = ["i=-1",
			"v=-1",
			"seqin=" + os.path.join(self.options["uniprot_dir"],"fasta",accession + ".fasta"),
			"runpath=" + self.options['alignment_dir'],
			"orthdb=" + self.options["orthdb"],
			"blastpath=" + self.options["blastpath"],
			"clustalw=" + self.options["clustalw"],
			"muscle=" + self.options["muscle"],
			"force=T",
			"minsim=25"]
			
			gopher_V2.Gopher(log=None,cmd_list=cmd_list).run()
			#os.remove(os.path.join(alignmentDir,"ALN",accession + ".orthaln.fas.clustalin"))
			
		except Exception,e:
			print e
	
	def readAlignment(self,id,alignmentPath):
		self.options["alignment"] = alignmentPath
		
		self.seqs = rje_seq.SeqList(log=None,cmd_list=['maxgap=0.2','maxx=0.2','gapfilter=T','v=-1','i=-1', 'iuchdir=T','relcons=T',"iucut=0.2","iumethod=short",'replacechar=F','stripnum=F',"iupath=" + self.options["iupath"] ])
		self.seqs.loadSeqs(seqfile=self.options["alignment"])
		self.seqs.querySeq(self.seqs.seq[0].info['AccNum'])
		self.seqs.tidyQueryGaps()
		self.seqs.gapSeqFilter()

if __name__ == "__main__":
	helper = alignmentHelper()
	
	accession = sys.argv[1]
	
	helper.makeAlignment(accession)